
#ifndef _IMAGE_SPLITTER_H_
#define _IMAGE_SPLITTER_H_

#define PANE_ROW_COL_LIST		0,0
#define PANE_ROW_COL_PAGE		0,1

class GridTest	: public GridTreeControl
{
public:
	void Init(int nID, WndContainer& dlg)
	{
		GridTreeControl::Init(nID, dlg);
	}
	
	void ShowGraphList(const TreeNode& trFuncList)
	{
		Tree trGraphList;
		trGraphList.AddNode("Graph1");
		trGraphList.AddNode("Graph2");
		m_trList = trGraphList;
		AddTreeNodes(m_trList, 0, NULL, -1, NULL, true, 0);
	}

private:
	TreeNode	m_trList;
};


class ImageSplitter : public SplitterControl
{
public:
	ImageSplitter();
	~ImageSplitter();
	
	void Init(int nCntrlID, WndContainer& wndParent, int nIndex = 0, LPCSTR lpcszDlgName = NULL)
	{
		SetGridSize(1,2);

		m_IDTreePane = GetDlgCtrlID(PANE_ROW_COL_LIST);
		m_IDPagePane = GetDlgCtrlID(PANE_ROW_COL_PAGE);
		
		InitMsgMap();
		SplitterControl::Init(nCntrlID, wndParent, 1, lpcszDlgName);// 1 = 2nd splitter in dialog
	}

protected:

EVENTS_BEGIN
	ON_INIT(OnInitSplitter)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnResize)
	ON_GRID_ROW_COL_CHANGE(m_IDTreePane, OnRowChange)
EVENTS_END

	BOOL OnInitSplitter();
	BOOL OnDestroy();
	BOOL OnResize(int nType, int cx, int cy);
	BOOL OnRowChange(Control ctrl);
	
private:
	int					m_IDTreePane;
	int					m_IDPagePane;
	PictureControl		m_picCtrl;
	GridTest			m_grid;
}; 
#endif //_IMAGE_SPLITTER_H_